# URL Cookie Plugin

This sample plugin shows how you can pass a cookie to the server as URL Parameter. This can be helpful to handle problems with cross-site scripting. Of course the use of a crossdomain.xml is a better solution.

The passing of a cookie can be helpful if you want to implement an SSO authentication between two or more servers.

The name of the URL parameter being passed in this specific sample is "urlCookie".

If you want to write your own URL special handling plugin then you need to create an instance of `jakarta.servlet.Filter` and register it in the ServerPluginManager. For more information please see the source files of this sample and the chapter `Platform Programming Guide | Plugins` in the Help of the SDK.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin, the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `jakarta.servlet-api.jar` (included in the `core` directory)
  * `jakarta.websocket-api.jar` (included in the `core` directory)
  * `jakarta.websocket-client-api.jar` (included in the `core` directory)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `urlcookie.sample.jar`. It also must contain the compiled sources as well as any required language resources and images.

The target plugin is a zip file, named `urlcookie.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin - but of course, any other build system will work just as well. 

## Deploying

In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

